"use strict";!function(root,factory){"function"==typeof define&&define.amd?define(["./ResizeSensor.js"],factory):"object"==typeof exports?module.exports=factory(require("./ResizeSensor.js")):(root.ElementQueries=factory(root.ResizeSensor),root.ElementQueries.listen())}("undefined"!=typeof window?window:this,(function(ResizeSensor){var ElementQueries=function(){var cssStyleElement,allQueries={},idToSelectorMapping=[];function getEmSize(element){element||(element=document.documentElement);var fontSize=window.getComputedStyle(element,null).fontSize;return parseFloat(fontSize)||16}function getElementSize(element){if(!element.getBoundingClientRect)return{width:element.offsetWidth,height:element.offsetHeight};var rect=element.getBoundingClientRect();return{width:Math.round(rect.width),height:Math.round(rect.height)}}function convertToPx(element,value){var numbers=value.split(/\d/),units=numbers[numbers.length-1];switch(value=parseFloat(value),units){case"px":return value;case"em":return value*getEmSize(element);case"rem":return value*getEmSize();case"vw":return value*document.documentElement.clientWidth/100;case"vh":return value*document.documentElement.clientHeight/100;case"vmin":case"vmax":var vw=document.documentElement.clientWidth/100,vh=document.documentElement.clientHeight/100,chooser;return value*(0,Math["vmin"===units?"min":"max"])(vw,vh);default:return value}}function SetupInformation(element,id){var key,option,elementSize,value,actualValue,attrValues,attrValue,attrName;this.element=element;var attributes=["min-width","min-height","max-width","max-height"];this.call=function(){for(key in elementSize=getElementSize(this.element),attrValues={},allQueries[id])allQueries[id].hasOwnProperty(key)&&(option=allQueries[id][key],value=convertToPx(this.element,option.value),actualValue="width"===option.property?elementSize.width:elementSize.height,attrName=option.mode+"-"+option.property,attrValue="","min"===option.mode&&actualValue>=value&&(attrValue+=option.value),"max"===option.mode&&actualValue<=value&&(attrValue+=option.value),attrValues[attrName]||(attrValues[attrName]=""),attrValue&&-1===(" "+attrValues[attrName]+" ").indexOf(" "+attrValue+" ")&&(attrValues[attrName]+=" "+attrValue));for(var k in attributes)attributes.hasOwnProperty(k)&&(attrValues[attributes[k]]?this.element.setAttribute(attributes[k],attrValues[attributes[k]].substr(1)):this.element.removeAttribute(attributes[k]))}}function setupElement(element,id){element.elementQueriesSetupInformation||(element.elementQueriesSetupInformation=new SetupInformation(element,id)),element.elementQueriesSensor||(element.elementQueriesSensor=new ResizeSensor(element,(function(){element.elementQueriesSetupInformation.call()})))}function queueQuery(selector,mode,property,value){if(void 0===allQueries[selector]){allQueries[selector]=[];var id=idToSelectorMapping.length;cssStyleElement.innerHTML+="\n"+selector+" {animation: 0.1s element-queries;}",cssStyleElement.innerHTML+="\n"+selector+" > .resize-sensor {min-width: "+id+"px;}",idToSelectorMapping.push(selector)}allQueries[selector].push({mode:mode,property:property,value:value})}function getQuery(container){var query;if(document.querySelectorAll&&(query=container?container.querySelectorAll.bind(container):document.querySelectorAll.bind(document)),query||"undefined"==typeof $$||(query=$$),query||"undefined"==typeof jQuery||(query=jQuery),!query)throw"No document.querySelectorAll, jQuery or Mootools's $$ found.";return query}function findElementQueriesElements(container){var query=getQuery(container);for(var selector in allQueries)if(allQueries.hasOwnProperty(selector))for(var elements=query(selector,container),i=0,j=elements.length;i<j;i++)setupElement(elements[i],selector)}function attachResponsiveImage(element){var children=[],rules=[],sources=[],defaultImageId=0,lastActiveImage=-1,loadedImages=[];for(var i in element.children)if(element.children.hasOwnProperty(i)&&element.children[i].tagName&&"img"===element.children[i].tagName.toLowerCase()){children.push(element.children[i]);var minWidth=element.children[i].getAttribute("min-width")||element.children[i].getAttribute("data-min-width"),src=element.children[i].getAttribute("data-src")||element.children[i].getAttribute("url");sources.push(src);var rule={minWidth:minWidth};rules.push(rule),minWidth?element.children[i].style.display="none":(defaultImageId=children.length-1,element.children[i].style.display="block")}function check(){var imageToDisplay=!1,i;for(i in children)children.hasOwnProperty(i)&&rules[i].minWidth&&element.offsetWidth>rules[i].minWidth&&(imageToDisplay=i);if(imageToDisplay||(imageToDisplay=defaultImageId),lastActiveImage!==imageToDisplay)if(loadedImages[imageToDisplay])children[lastActiveImage].style.display="none",children[imageToDisplay].style.display="block",lastActiveImage=imageToDisplay;else{var image=new Image;image.onload=function(){children[imageToDisplay].src=sources[imageToDisplay],children[lastActiveImage].style.display="none",children[imageToDisplay].style.display="block",loadedImages[imageToDisplay]=!0,lastActiveImage=imageToDisplay},image.src=sources[imageToDisplay]}else children[imageToDisplay].src=sources[imageToDisplay]}lastActiveImage=defaultImageId,element.resizeSensorInstance=new ResizeSensor(element,check),check()}function findResponsiveImages(){for(var query,elements=getQuery()("[data-responsive-image],[responsive-image]"),i=0,j=elements.length;i<j;i++)attachResponsiveImage(elements[i])}var regex=/,?[\s\t]*([^,\n]*?)((?:\[[\s\t]*?(?:min|max)-(?:width|height)[\s\t]*?[~$\^]?=[\s\t]*?"[^"]*?"[\s\t]*?])+)([^,\n\s\{]*)/gim,attrRegex=/\[[\s\t]*?(min|max)-(width|height)[\s\t]*?[~$\^]?=[\s\t]*?"([^"]*?)"[\s\t]*?]/gim;function extractQuery(css){var match,smatch,attrs,attrMatch;for(css=css.replace(/'/g,'"');null!==(match=regex.exec(css));)for(smatch=match[1]+match[3],attrs=match[2];null!==(attrMatch=attrRegex.exec(attrs));)queueQuery(smatch,attrMatch[1],attrMatch[2],attrMatch[3])}function readRules(rules){var selector="";if(rules)if("string"==typeof rules)-1===(rules=rules.toLowerCase()).indexOf("min-width")&&-1===rules.indexOf("max-width")||extractQuery(rules);else for(var i=0,j=rules.length;i<j;i++)1===rules[i].type?-1!==(selector=rules[i].selectorText||rules[i].cssText).indexOf("min-height")||-1!==selector.indexOf("max-height")?extractQuery(selector):-1===selector.indexOf("min-width")&&-1===selector.indexOf("max-width")||extractQuery(selector):4===rules[i].type?readRules(rules[i].cssRules||rules[i].rules):3===rules[i].type&&rules[i].styleSheet.hasOwnProperty("cssRules")&&readRules(rules[i].styleSheet.cssRules)}var defaultCssInjected=!1;this.init=function(){var animationStart="animationstart";void 0!==document.documentElement.style.webkitAnimationName?animationStart="webkitAnimationStart":void 0!==document.documentElement.style.MozAnimationName?animationStart="mozanimationstart":void 0!==document.documentElement.style.OAnimationName&&(animationStart="oanimationstart"),document.body.addEventListener(animationStart,(function(e){var element=e.target,styles=element&&window.getComputedStyle(element,null),animationName=styles&&styles.getPropertyValue("animation-name"),requiresSetup;if(animationName&&-1!==animationName.indexOf("element-queries")){element.elementQueriesSensor=new ResizeSensor(element,(function(){element.elementQueriesSetupInformation&&element.elementQueriesSetupInformation.call()}));var sensorStyles,id=window.getComputedStyle(element.resizeSensor,null).getPropertyValue("min-width");id=parseInt(id.replace("px","")),setupElement(e.target,idToSelectorMapping[id])}})),defaultCssInjected||((cssStyleElement=document.createElement("style")).type="text/css",cssStyleElement.innerHTML="[responsive-image] > img, [data-responsive-image] {overflow: hidden; padding: 0; } [responsive-image] > img, [data-responsive-image] > img {width: 100%;}",cssStyleElement.innerHTML+="\n@keyframes element-queries { 0% { visibility: inherit; } }",document.getElementsByTagName("head")[0].appendChild(cssStyleElement),defaultCssInjected=!0);for(var i=0,j=document.styleSheets.length;i<j;i++)try{document.styleSheets[i].href&&0===document.styleSheets[i].href.indexOf("file://")&&console.warn("CssElementQueries: unable to parse local css files, "+document.styleSheets[i].href),readRules(document.styleSheets[i].cssRules||document.styleSheets[i].rules||document.styleSheets[i].cssText)}catch(e){}findResponsiveImages()},this.findElementQueriesElements=function(container){findElementQueriesElements(container)},this.update=function(){this.init()}};ElementQueries.update=function(){ElementQueries.instance.update()},ElementQueries.detach=function(element){element.elementQueriesSetupInformation?(element.elementQueriesSensor.detach(),delete element.elementQueriesSetupInformation,delete element.elementQueriesSensor):element.resizeSensorInstance&&(element.resizeSensorInstance.detach(),delete element.resizeSensorInstance)},ElementQueries.init=function(){ElementQueries.instance||(ElementQueries.instance=new ElementQueries),ElementQueries.instance.init()};var domLoaded=function(callback){if(document.addEventListener)document.addEventListener("DOMContentLoaded",callback,!1);else if(/KHTML|WebKit|iCab/i.test(navigator.userAgent))var DOMLoadTimer=setInterval((function(){/loaded|complete/i.test(document.readyState)&&(callback(),clearInterval(DOMLoadTimer))}),10);else window.onload=callback};return ElementQueries.findElementQueriesElements=function(container){ElementQueries.instance.findElementQueriesElements(container)},ElementQueries.listen=function(){domLoaded(ElementQueries.init)},ElementQueries}));